
<?php $__env->startSection('title', __('Third-Party API Setting')); ?>

<?php $__env->startSection('has-content-sidebar', 'has-content-sidebar'); ?>

<?php $__env->startSection('content-sidebar'); ?>
    <?php echo $__env->make('admin.settings.content-sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

	<div class="nk-content-body">
        <div class="nk-block-head nk-block-head-sm">
            <div class="nk-block-between">
                <div class="nk-block-head-content">
                    <h3 class="nk-block-title page-title"><?php echo e(__('Third-Party API')); ?></h3>
                    <p><?php echo e(__('Set third-party API credential to enable relevent feature.')); ?></p>
                </div>
                <div class="nk-block-head-content">
                    <ul class="nk-block-tools gx-1">
                        <li class="d-lg-none">
                            <a href="#" class="btn btn-icon btn-trigger toggle" data-target="pageSidebar"><em class="icon ni ni-menu-right"></em></a>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
        <div class="nk-block card card-bordered nk-block-mh">
            <div class="card-inner">
                <form action="<?php echo e(route('admin.save.app.settings')); ?>" class="form-settings" method="POST">
                    <div class="form-sets gy-3 wide-md">
                        <div class="row g-3 align-start">
                            <div class="col-lg-5">
                                <div class="form-group">
                                    <label class="form-label" for="tawk-api"><?php echo e(__('Tawk API Key for Live Chat')); ?></label>
                                    <span class="form-note">
                                    	<?php echo e(__('You can add the Tawk.to live chat widget to your website.')); ?> <br>
                                    	<?php echo __("If you don't have, get your API from :external website.", ['external' => '<a href="https://www.tawk.to/" target="_blank">Tawk.to</a>']); ?>

                                    </span>
                                </div>
                            </div>
                            <div class="col-lg-7">
                                <div class="form-group">
                                    <div class="form-control-wrap">
                                        <input type="text" class="form-control" id="tawk-api" name="tawk_api_key" value="<?php echo e(sys_settings('tawk_api_key')); ?>">
                                    </div>
                                    <div class="form-note">
                                    	<?php echo e(__('Tawk API Key')); ?>

                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="divider"></div>
                    <div class="form-sets gy-3 wide-md">
                        <div class="row g-3 align-start">
                            <div class="col-lg-5">
                                <div class="form-group">
                                    <label class="form-label" for="exratesapi-access-key"><?php echo e(__('ExRatesApi Access Key')); ?></label>
                                    <span class="form-note">
                                        <?php echo e(__('To get live exchange rate from ExRatesApi.com.')); ?> <br><span class="text-primary"><?php echo e(__("Application has build in access key that integrate with API.")); ?></span>
                                    </span>
                                </div>
                            </div>
                            <div class="col-lg-7">
                                <div class="form-group">
                                    <div class="form-control-wrap">
                                        <input type="text" class="form-control" id="exratesapi-access-key" name="exratesapi_access_key" value="<?php echo e(sys_settings('exratesapi_access_key')); ?>" placeholder="<?php echo e(str_compact(get_ex_apikey(), '-xx-xx-', 8)); ?>">
                                    </div>
                                    <div class="form-note">
                                        <?php echo e(__('ExRatesAPI Access Key')); ?> / <span class="text-danger"><?php echo e(__("Do not change the key unless you've correct access key.")); ?></span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="divider"></div>
                    <div class="form-sets gy-3 wide-md">
                        <div class="row g-3 align-start">
                            <div class="col-lg-5">
                                <div class="form-group">
                                    <label class="form-label" for="recaptcha-sitekey"><?php echo e(__('Google reCaptcha v3')); ?></label>
                                    <span class="form-note">
                                    	<?php echo e(__('To enable captcha on login, registration page.')); ?> <br>
                                    	<?php echo __('Get the API Key :external', ['external' => '<a href="https://www.google.com/recaptcha/admin" target="_blank">https://www.google.com/recaptcha/admin</a>']); ?>

                                    </span>

                                </div>
                            </div>
                            <div class="col-lg-7">
                                <div class="form-group">
                                    <div class="form-control-wrap">
                                        <input type="text" class="form-control" id="recaptcha-sitekey" name="recaptcha_site_key" value="<?php echo e(sys_settings('recaptcha_site_key')); ?>">
                                    </div>
                                    <div class="form-note">
                                    	<strong><?php echo e(__('reCaptcha Site Key')); ?></strong>
                                    </div>
                                    <div class="form-control-wrap mt-2">
                                        <input type="text" class="form-control" id="recaptcha-seckey" name="recaptcha_secret_key" value="<?php echo e(sys_settings('recaptcha_secret_key')); ?>">
                                    </div>
                                    <div class="form-note">
                                    	<strong><?php echo e(__('reCaptcha Secret Key')); ?></strong>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="form-sets gy-3 wide-md">
                        <div class="row g-3">
                            <div class="col-lg-7 offset-lg-5">
                                <div class="form-group mt-2">
                                    <?php echo csrf_field(); ?>
                                    <input type="hidden" name="form_type" value="api-credential">
                                    <button type="button" class="btn btn-primary submit-settings" disabled="">
                                        <span class="spinner-border spinner-border-sm hide" role="status" aria-hidden="true"></span>
                                        <span><?php echo e(__('Update')); ?></span>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\frank\Desktop\xammp\htdocs\invest1\core_invapp\resources\views/admin/settings/api.blade.php ENDPATH**/ ?>