
<?php $__env->startSection('title', __('Bank Transfer - Payment Method')); ?>

<?php $__env->startSection('content'); ?>
    <div class="nk-content-body">
        <div class="nk-block-head nk-block-head-sm">
            <div class="nk-block-between">
                <div class="nk-block-head-content">
                    <h3 class="nk-block-title page-title"><?php echo e(__('Payment Methods')); ?></h3>
                    <p><?php echo e(__('Manage payment methods to receive payment from user.')); ?></p>
                </div>
                <div class="nk-block-head-content">
                    <ul class="nk-block-tools gx-1">
                        <li class="d-lg-none">
                            <a href="javascript:void(0)" class="btn btn-icon btn-trigger toggle" data-target="pageSidebar"><em class="icon ni ni-menu-right"></em></a>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
        <div class="nk-block card card-bordered nk-block-mh">
            <div class="card-inner">
                <div class="justify-between">
                    <h5 class="title"><?php echo e(__('Bank Transfer')); ?> <span class="meta ml-1"><span class="badge badge-pill badge-xs badge-light"><?php echo e(__('Core')); ?></span></span></h5>
                    <div class="go-back"><a class="back-to" href="<?php echo e(route('admin.settings.gateway.payment.list')); ?>"><em class="icon ni ni-arrow-left"> </em> <?php echo e(__('Back')); ?></a></div>
                </div>
                <p><?php echo e(__('Accept payment directly via your local bank transfer.')); ?></p>
                <div class="divider"></div>
                <div class="row">
                    <div class="col-12">
                        <form action="<?php echo e(route('admin.settings.gateway.payment.bank-transfer.save')); ?>" class="form-settings" method="POST">
                            <div class="form-set wide-sm">
                                <h6 class="title mb-3"><?php echo e(__('Method Setting')); ?></h6>
                                <div class="row gy-3">
                                    <div class="col-12 col-md-12 col-lg-6">
                                        <div class="form-group">
                                            <label class="form-label"><?php echo e(__('Method Title')); ?> <span class="text-danger">*</span></label>
                                            <div class="form-control-wrap">
                                                <input type="text" name="name" class="form-control" value="<?php echo e(data_get($settings, 'name', __('Pay via Bank Transfer'))); ?>">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-12 col-md-12 col-lg-6">
                                        <div class="form-group">
                                            <label class="form-label"><?php echo e(__('Description')); ?> <span class="text-danger">*</span></label>
                                            <div class="form-control-group">
                                                <input type="text" name="desc" value="<?php echo e(data_get($settings, 'desc', __('Make payment directly into our bank account.'))); ?>" class="form-control">
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-12 col-md-6">
                                        <div class="form-group">
                                            <label class="form-label"><?php echo e(__('Minimum Amount')); ?> <small><sup>1</sup></small></label>
                                            <div class="form-control-wrap">
                                                <div class="form-text-hint"><span><?php echo e(base_currency()); ?></span></div>
                                                <input type="number" class="form-control" name="min_amount" value="<?php echo e(data_get($settings, 'min_amount', '0')); ?>" min="0">
                                            </div>
                                            <div class="form-note"><?php echo e(__('Amount will be convert.')); ?></div>
                                        </div>
                                    </div>

                                    <div class="col-12 col-md-6">
                                        <div class="form-group opt-disable" title="<?php echo e(__('Upcoming future update for extended license.')); ?>" data-toggle="tooltip">
                                            <label class="form-label" for="gateway-fee"><?php echo e(__('Fees')); ?> <span>(<?php echo e(__('per transaction')); ?>)</span></label>
                                            <div class="row g-2">
                                                <div class="col-6">
                                                    <div class="form-control-wrap">
                                                        <div class="form-text-hint">
                                                            <span class="overline-title"><?php echo e(__('P')); ?></span>
                                                        </div>
                                                        <input type="text" disabled="" class="form-control" id="gateway-fee-percent" placeholder="0">
                                                    </div>
                                                    <div class="form-note"><?php echo e(__('Percent Fee')); ?></div>
                                                </div>
                                                <div class="col-6">
                                                    <div class="form-control-wrap">
                                                        <div class="form-text-hint">
                                                            <span class="overline-title"><?php echo e(__('F')); ?></span>
                                                        </div>
                                                        <input type="text" disabled="" class="form-control" id="gateway-fee-flat" placeholder="0">
                                                    </div>
                                                    <div class="form-note"><?php echo e(__('Flat Fee')); ?></div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-12 col-md-6 col-lg-9 col-xxl-6">
                                        <div class="row gx-gs gy-3">
                                            <div class="col-12 col-sm-7">
                                                <div class="form-group">
                                                    <label class="form-label" for="currency-supported"><?php echo e(__('Supported Currency')); ?></label>
                                                    <div class="form-control-wrap">
                                                        <select name="currencies[]" class="form-select">
                                                            <?php $__currentLoopData = $supportedCurrencies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $currency): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <option value="<?php echo e(data_get($currency, 'code')); ?>"<?php echo e((in_array(data_get($currency, 'code'), data_get($settings, 'currencies', []))) ? ' selected' : ''); ?><?php echo e(!is_active_currency(data_get($currency, 'code')) ? ' disabled' : ''); ?>>
                                                                    <?php echo e(__(':name (:code)', ["name" => data_get($currency, 'name'), "code" => data_get($currency, 'code')])); ?>

                                                                </option>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        </select>
                                                    </div>
                                                    <div class="form-note"><?php echo e(__('Local currency as per your bank.')); ?></div>
                                                </div>
                                            </div>
                                            <div class="col-12 col-sm-5">
                                                <div class="form-group">
                                                    <label class="form-label"><?php echo e(__('Fixed Minimum')); ?> <small><sup>2</sup></small></label>
                                                    <div class="form-control-wrap">
                                                        <input type="number" class="form-control" name="config[meta][min]" value="<?php echo e(data_get($settings, 'config.meta.min', '0')); ?>" min="0">
                                                    </div>
                                                    <div class="form-note"><?php echo e(__('Fixed Amount')); ?></div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-12 col-md-6 col-lg-9 col-xxl-6">
                                        <div class="form-group">
                                            <label class="form-label"><?php echo e(__('Method Name')); ?> <span class="small"><?php echo e(__('Alternet')); ?></span></label>
                                            <div class="form-control-wrap">
                                                <input type="text" name="config[meta][title]" class="form-control" value="<?php echo e(data_get($settings, 'config.meta.title')); ?>">
                                            </div>
                                            <div class="form-note"><?php echo e(__('Method title will use if leave blank.')); ?></div>
                                        </div>
                                    </div>
                                    <div class="col-12">
                                        <div class="note mt-2 pl-2 border-left border-primary">
                                            <p><strong><?php echo e(__('Please Note:')); ?></strong><br>
                                                <small><sup>1</sup></small> 
                                                <?php echo e(__("The amount will apply only if its more than the base minimum deposit amount.")); ?><br>
                                                <small><sup>2</sup></small> 
                                                <?php echo e(__("The fixed minimum amount will be set and override to any minimum deposit amount.")); ?>

                                            </p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="divider"></div>
                            <div class="form-set wide-sm">
                                <h6 class="title"><?php echo e(__('Bank Account Details')); ?></h6>
                                <div class="form-sets gy-3 wide-md">
                                    <div class="row g-3 align-center">
                                        <div class="col-lg-5">
                                            <div class="form-group">
                                                <label class="form-label"><?php echo e(__('Account name')); ?> <span class="text-danger">*</span></label>
                                                <span class="form-note"><?php echo e(__('Specify the name of your bank account')); ?></span>
                                            </div>
                                        </div>
                                        <div class="col-lg-7">
                                            <div class="form-group">
                                                <div class="form-control-wrap">
                                                    <input type="text" class="form-control" name="config[ac][account_name]" value="<?php echo e(data_get($settings, 'config.ac.account_name')); ?>">
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row g-3 align-center">
                                        <div class="col-lg-5">
                                            <div class="form-group">
                                                <label class="form-label"><?php echo e(__('Account Number')); ?> <span class="text-danger">*</span></label>
                                                <span class="form-note"><?php echo e(__('Specify your bank account number')); ?></span>
                                            </div>
                                        </div>
                                        <div class="col-lg-7">
                                            <div class="form-group">
                                                <div class="form-control-wrap">
                                                    <input type="text" class="form-control" name="config[ac][account_number]" value="<?php echo e(data_get($settings, 'config.ac.account_number')); ?>">
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row g-3 align-center">
                                        <div class="col-lg-5">
                                            <div class="form-group">
                                                <label class="form-label"><?php echo e(__('Account Holder Address')); ?></label>
                                                <span class="form-note"><?php echo e(__('Address associated with your bank account.')); ?></span>
                                            </div>
                                        </div>
                                        <div class="col-lg-7">
                                            <div class="form-group">
                                                <div class="form-control-wrap">
                                                    <input type="text" class="form-control" name="config[ac][account_address]" value="<?php echo e(data_get($settings, 'config.ac.account_address')); ?>">
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row g-3 align-center">
                                        <div class="col-lg-5">
                                            <div class="form-group">
                                                <label class="form-label"><?php echo e(__('Bank Name')); ?> <span class="text-danger">*</span></label>
                                                <span class="form-note"><?php echo e(__('Specify the name of your bank.')); ?></span>
                                            </div>
                                        </div>
                                        <div class="col-lg-7">
                                            <div class="form-group">
                                                <div class="form-control-wrap">
                                                    <input type="text" class="form-control" name="config[ac][bank_name]" value="<?php echo e(data_get($settings, 'config.ac.bank_name')); ?>">
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row g-3 align-center">
                                        <div class="col-lg-5">
                                            <div class="form-group">
                                                <label class="form-label"><?php echo e(__('Bank Short Name')); ?> <span class="text-danger">*</span></label>
                                                <span class="form-note"><?php echo e(__('Specify a short name of your bank.')); ?></span>
                                            </div>
                                        </div>
                                        <div class="col-lg-7">
                                            <div class="form-group">
                                                <div class="form-control-wrap">
                                                    <input type="text" class="form-control" name="config[ac][bank_short]" value="<?php echo e(data_get($settings, 'config.ac.bank_short')); ?>">
                                                </div>
                                                <div class="form-note"><?php echo e(__('System use only for record.')); ?></div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row g-3 align-center">
                                        <div class="col-lg-5">
                                            <div class="form-group">
                                                <label class="form-label"><?php echo e(__('Bank Branch')); ?></label>
                                                <span class="form-note"><?php echo e(__('The branch name of your bank.')); ?></span>
                                            </div>
                                        </div>
                                        <div class="col-lg-7">
                                            <div class="form-group">
                                                <div class="form-control-wrap">
                                                    <input type="text" class="form-control" name="config[ac][bank_branch]" value="<?php echo e(data_get($settings, 'config.ac.bank_branch')); ?>">
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row g-3 align-center">
                                        <div class="col-lg-5">
                                            <div class="form-group">
                                                <label class="form-label"><?php echo e(__('Bank Address')); ?></label>
                                                <span class="form-note"><?php echo e(__('The bank address of your bank.')); ?></span>
                                            </div>
                                        </div>
                                        <div class="col-lg-7">
                                            <div class="form-group">
                                                <div class="form-control-wrap">
                                                    <input type="text" class="form-control" name="config[ac][bank_address]" value="<?php echo e(data_get($settings, 'config.ac.bank_address')); ?>">
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row g-3 align-center">
                                        <div class="col-lg-5">
                                            <div class="form-group">
                                                <label class="form-label"><?php echo e(__('Routing Number')); ?></label>
                                                <span class="form-note"><?php echo e(__('Routing number for your bank account.')); ?></span>
                                            </div>
                                        </div>
                                        <div class="col-lg-7">
                                            <div class="form-group">
                                                <div class="form-control-wrap">
                                                    <input type="text" class="form-control" name="config[ac][routing]" value="<?php echo e(data_get($settings, 'config.ac.routing')); ?>">
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row g-3 align-center">
                                        <div class="col-lg-5">
                                            <div class="form-group">
                                                <label class="form-label"><?php echo e(__('Sort code')); ?></label>
                                                <span class="form-note"><?php echo e(__('Sort code for your bank account.')); ?></span>
                                            </div>
                                        </div>
                                        <div class="col-lg-7">
                                            <div class="form-group">
                                                <div class="form-control-wrap">
                                                    <input type="text" class="form-control" name="config[ac][sortcode]" value="<?php echo e(data_get($settings, 'config.ac.sortcode')); ?>">
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row g-3 align-center">
                                        <div class="col-lg-5">
                                            <div class="form-group">
                                                <label class="form-label"><?php echo e(__('IBAN')); ?></label>
                                                <span class="form-note"><?php echo e(__('International bank account number of your account.')); ?></span>
                                            </div>
                                        </div>
                                        <div class="col-lg-7">
                                            <div class="form-group">
                                                <div class="form-control-wrap">
                                                    <input type="text" class="form-control" name="config[ac][iban]" value="<?php echo e(data_get($settings, 'config.ac.iban')); ?>">
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row g-3 align-center">
                                        <div class="col-lg-5">
                                            <div class="form-group">
                                                <label class="form-label"><?php echo e(__('Swift/BIC')); ?></label>
                                                <span class="form-note"><?php echo e(__('Swift/BIC for your bank account')); ?></span>
                                            </div>
                                        </div>
                                        <div class="col-lg-7">
                                            <div class="form-group">
                                                <div class="form-control-wrap">
                                                    <input type="text" class="form-control" name="config[ac][swift]" value="<?php echo e(data_get($settings, 'config.ac.swift')); ?>">
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="divider"></div>
                            <div class="d-flex justify-between">
                                <?php echo csrf_field(); ?>
                                <input type="hidden" name="slug" value="<?php echo e(data_get($config, 'slug')); ?>">
                                <div class="custom-control custom-switch">
                                    <input class="switch-option-value" type="hidden" name="status" value="<?php echo e(data_get($settings, 'status') ?? 'inactive'); ?>">
                                    <input type="checkbox" class="custom-control-input switch-option" data-switch="active"<?php echo e((data_get($settings, 'status', 'inactive') == 'active') ? ' checked=""' : ''); ?>  id="enable-method">
                                    <label class="custom-control-label" for="enable-method"><span class="over"></span><span><?php echo e(__('Enable Method')); ?></span></label>
                                </div>
                                <button type="button" class="btn btn-primary submit-settings" disabled="">
                                    <span class="spinner-border spinner-border-sm hide" role="status" aria-hidden="true"></span>
                                    <span><?php echo e(__('Update')); ?></span>
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.modules', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\frank\Desktop\xammp\htdocs\invest1\core_invapp\niomodules\Bank\Views/settings.blade.php ENDPATH**/ ?>